<?php











namespace Composer;

use Composer\Autoload\ClassLoader;
use Composer\Semver\VersionParser;








class InstalledVersions
{
private static $installed = array (
  'root' => 
  array (
    'pretty_version' => 'dev-master',
    'version' => 'dev-master',
    'aliases' => 
    array (
    ),
    'reference' => NULL,
    'name' => 'automattic/jetpack',
  ),
  'versions' => 
  array (
    'automattic/jetpack' => 
    array (
      'pretty_version' => 'dev-master',
      'version' => 'dev-master',
      'aliases' => 
      array (
      ),
      'reference' => NULL,
    ),
    'automattic/jetpack-a8c-mc-stats' => 
    array (
      'pretty_version' => 'v1.4.4',
      'version' => '1.4.4.0',
      'aliases' => 
      array (
      ),
      'reference' => '59df714196e8ac4fd69a4ddedcb9dbeb12e7ecb5',
    ),
    'automattic/jetpack-abtest' => 
    array (
      'pretty_version' => 'v1.9.8',
      'version' => '1.9.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '0749a3fc78004062244af888cb2f8cb1be06634e',
    ),
    'automattic/jetpack-assets' => 
    array (
      'pretty_version' => 'v1.11.5',
      'version' => '1.11.5.0',
      'aliases' => 
      array (
      ),
      'reference' => '88f04c6eb63ee4ce801735c03f7db5cae05e79bc',
    ),
    'automattic/jetpack-autoloader' => 
    array (
      'pretty_version' => 'v2.10.3',
      'version' => '2.10.3.0',
      'aliases' => 
      array (
      ),
      'reference' => 'aab966d6f2c8fd6669d6f5b1378d8ced5fd665b4',
    ),
    'automattic/jetpack-backup' => 
    array (
      'pretty_version' => 'v1.1.0',
      'version' => '1.1.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'a35922fe69fac317cfd8f2345395813b273ba650',
    ),
    'automattic/jetpack-blocks' => 
    array (
      'pretty_version' => 'v1.4.1',
      'version' => '1.4.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '2d8e214bb64856cc4e2413af2e3252c241c668ca',
    ),
    'automattic/jetpack-compat' => 
    array (
      'pretty_version' => 'v1.6.5',
      'version' => '1.6.5.0',
      'aliases' => 
      array (
      ),
      'reference' => '8101adbec7971bae8746108a6fd261afae99524c',
    ),
    'automattic/jetpack-config' => 
    array (
      'pretty_version' => 'v1.4.6',
      'version' => '1.4.6.0',
      'aliases' => 
      array (
      ),
      'reference' => '98f8080550901a8a29daf466ee75a4906c5f1ef0',
    ),
    'automattic/jetpack-connection' => 
    array (
      'pretty_version' => 'v1.29.0',
      'version' => '1.29.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '47789f8b56171ae226931da28764d3b1c9f2f95b',
    ),
    'automattic/jetpack-connection-ui' => 
    array (
      'pretty_version' => 'v1.2.0',
      'version' => '1.2.0.0',
      'aliases' => 
      array (
      ),
      'reference' => 'a310c2ba3556263e2a8ac66da6a207f71eec506c',
    ),
    'automattic/jetpack-constants' => 
    array (
      'pretty_version' => 'v1.6.5',
      'version' => '1.6.5.0',
      'aliases' => 
      array (
      ),
      'reference' => '1e02eebb828c6701f3bf97fa8404e9fc85d3fb63',
    ),
    'automattic/jetpack-device-detection' => 
    array (
      'pretty_version' => 'v1.4.2',
      'version' => '1.4.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '6f7c0560cac114a99066a703cf66813e325e8630',
    ),
    'automattic/jetpack-error' => 
    array (
      'pretty_version' => 'v1.3.5',
      'version' => '1.3.5.0',
      'aliases' => 
      array (
      ),
      'reference' => 'f81fa17c2afb559dd12c52dae8aedb44da6a4195',
    ),
    'automattic/jetpack-heartbeat' => 
    array (
      'pretty_version' => 'v1.3.8',
      'version' => '1.3.8.0',
      'aliases' => 
      array (
      ),
      'reference' => 'ed630c4a9271d5ce2bba15eec4ff32c448330b67',
    ),
    'automattic/jetpack-identity-crisis' => 
    array (
      'pretty_version' => 'v0.2.0',
      'version' => '0.2.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '70032ca911cfe2229a047b3aada82595cc75283f',
    ),
    'automattic/jetpack-jitm' => 
    array (
      'pretty_version' => 'v1.16.1',
      'version' => '1.16.1.0',
      'aliases' => 
      array (
      ),
      'reference' => 'b47922ac910f64405a4de3cece16dffde9edeb4b',
    ),
    'automattic/jetpack-lazy-images' => 
    array (
      'pretty_version' => 'v1.5.0',
      'version' => '1.5.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '27d9a86239c61093557d9256bf9d46e589b384cc',
    ),
    'automattic/jetpack-licensing' => 
    array (
      'pretty_version' => 'v1.4.3',
      'version' => '1.4.3.0',
      'aliases' => 
      array (
      ),
      'reference' => 'd6017a2e59f4611964980371e2bf146c21af39b5',
    ),
    'automattic/jetpack-logo' => 
    array (
      'pretty_version' => 'v1.5.5',
      'version' => '1.5.5.0',
      'aliases' => 
      array (
      ),
      'reference' => '4b4a24e30ac76beea19a4d75b451e2b7a287db4c',
    ),
    'automattic/jetpack-options' => 
    array (
      'pretty_version' => 'v1.13.0',
      'version' => '1.13.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '2606ae27f9b4336ca1b34ee9ecd99ac658ef30fc',
    ),
    'automattic/jetpack-partner' => 
    array (
      'pretty_version' => 'v1.5.1',
      'version' => '1.5.1.0',
      'aliases' => 
      array (
      ),
      'reference' => 'c5836805d2dd2367264408260d1f51a0a82a0203',
    ),
    'automattic/jetpack-password-checker' => 
    array (
      'pretty_version' => 'v0.1.2',
      'version' => '0.1.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '408bf765942578276da69b10c2600564773dceee',
    ),
    'automattic/jetpack-redirect' => 
    array (
      'pretty_version' => 'v1.7.0',
      'version' => '1.7.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '8320a82f8daee5127a2c3e19cb4e2566ba4c94bb',
    ),
    'automattic/jetpack-roles' => 
    array (
      'pretty_version' => 'v1.4.5',
      'version' => '1.4.5.0',
      'aliases' => 
      array (
      ),
      'reference' => 'd04bbd4e012516d280a610e3961edef5cf241722',
    ),
    'automattic/jetpack-status' => 
    array (
      'pretty_version' => 'v1.8.0',
      'version' => '1.8.0.0',
      'aliases' => 
      array (
      ),
      'reference' => '9da88ee253d69e4948c76e4080435aca23c65dbb',
    ),
    'automattic/jetpack-sync' => 
    array (
      'pretty_version' => 'v1.23.1',
      'version' => '1.23.1.0',
      'aliases' => 
      array (
      ),
      'reference' => '41172188c5f88560e7a4cdd26017393f845ae781',
    ),
    'automattic/jetpack-terms-of-service' => 
    array (
      'pretty_version' => 'v1.9.8',
      'version' => '1.9.8.0',
      'aliases' => 
      array (
      ),
      'reference' => '9ebb094dc1243b36c449ecb37a858511c9b41759',
    ),
    'automattic/jetpack-tracking' => 
    array (
      'pretty_version' => 'v1.13.7',
      'version' => '1.13.7.0',
      'aliases' => 
      array (
      ),
      'reference' => '8fd3b9aef38dd2dd9b072dfd9af5b9a3278b20b6',
    ),
    'nojimage/twitter-text-php' => 
    array (
      'pretty_version' => 'v3.1.2',
      'version' => '3.1.2.0',
      'aliases' => 
      array (
      ),
      'reference' => '979bcf6a92d543b61588c7c0c0a87d0eb473d8f6',
    ),
  ),
);
private static $canGetVendors;
private static $installedByVendor = array();







public static function getInstalledPackages()
{
$packages = array();
foreach (self::getInstalled() as $installed) {
$packages[] = array_keys($installed['versions']);
}

if (1 === \count($packages)) {
return $packages[0];
}

return array_keys(array_flip(\call_user_func_array('array_merge', $packages)));
}









public static function isInstalled($packageName)
{
foreach (self::getInstalled() as $installed) {
if (isset($installed['versions'][$packageName])) {
return true;
}
}

return false;
}














public static function satisfies(VersionParser $parser, $packageName, $constraint)
{
$constraint = $parser->parseConstraints($constraint);
$provided = $parser->parseConstraints(self::getVersionRanges($packageName));

return $provided->matches($constraint);
}










public static function getVersionRanges($packageName)
{
foreach (self::getInstalled() as $installed) {
if (!isset($installed['versions'][$packageName])) {
continue;
}

$ranges = array();
if (isset($installed['versions'][$packageName]['pretty_version'])) {
$ranges[] = $installed['versions'][$packageName]['pretty_version'];
}
if (array_key_exists('aliases', $installed['versions'][$packageName])) {
$ranges = array_merge($ranges, $installed['versions'][$packageName]['aliases']);
}
if (array_key_exists('replaced', $installed['versions'][$packageName])) {
$ranges = array_merge($ranges, $installed['versions'][$packageName]['replaced']);
}
if (array_key_exists('provided', $installed['versions'][$packageName])) {
$ranges = array_merge($ranges, $installed['versions'][$packageName]['provided']);
}

return implode(' || ', $ranges);
}

throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
}





public static function getVersion($packageName)
{
foreach (self::getInstalled() as $installed) {
if (!isset($installed['versions'][$packageName])) {
continue;
}

if (!isset($installed['versions'][$packageName]['version'])) {
return null;
}

return $installed['versions'][$packageName]['version'];
}

throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
}





public static function getPrettyVersion($packageName)
{
foreach (self::getInstalled() as $installed) {
if (!isset($installed['versions'][$packageName])) {
continue;
}

if (!isset($installed['versions'][$packageName]['pretty_version'])) {
return null;
}

return $installed['versions'][$packageName]['pretty_version'];
}

throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
}





public static function getReference($packageName)
{
foreach (self::getInstalled() as $installed) {
if (!isset($installed['versions'][$packageName])) {
continue;
}

if (!isset($installed['versions'][$packageName]['reference'])) {
return null;
}

return $installed['versions'][$packageName]['reference'];
}

throw new \OutOfBoundsException('Package "' . $packageName . '" is not installed');
}





public static function getRootPackage()
{
$installed = self::getInstalled();

return $installed[0]['root'];
}








public static function getRawData()
{
@trigger_error('getRawData only returns the first dataset loaded, which may not be what you expect. Use getAllRawData() instead which returns all datasets for all autoloaders present in the process.', E_USER_DEPRECATED);

return self::$installed;
}







public static function getAllRawData()
{
return self::getInstalled();
}



















public static function reload($data)
{
self::$installed = $data;
self::$installedByVendor = array();
}





private static function getInstalled()
{
if (null === self::$canGetVendors) {
self::$canGetVendors = method_exists('Composer\Autoload\ClassLoader', 'getRegisteredLoaders');
}

$installed = array();

if (self::$canGetVendors) {
foreach (ClassLoader::getRegisteredLoaders() as $vendorDir => $loader) {
if (isset(self::$installedByVendor[$vendorDir])) {
$installed[] = self::$installedByVendor[$vendorDir];
} elseif (is_file($vendorDir.'/composer/installed.php')) {
$installed[] = self::$installedByVendor[$vendorDir] = require $vendorDir.'/composer/installed.php';
}
}
}

$installed[] = self::$installed;

return $installed;
}
}
