<?php
/** Theme Custom Header */
radius_custom_header();
function radius_custom_header() {

	/** The default header text color */
	define( 'HEADER_TEXTCOLOR', '' );
	/** By leaving empty, we allow for random image rotation. */
	define( 'HEADER_IMAGE', '%s/images/logo.png' );
	/** The height and width of your custom header. */
	define( 'HEADER_IMAGE_WIDTH', 300 );
	define( 'HEADER_IMAGE_HEIGHT', 80 );
	/** Header Text */
	define( 'NO_HEADER_TEXT', true );
	
	/** Turn on random header image rotation by default. */
	add_theme_support( 'custom-header' );
	/** Add a way for the custom header to be styled in the admin panel that controls */
	add_custom_image_header( '', 'radius_admin_header_style' );	

}

/** Styles the header image displayed on the Appearance > Header admin panel. */
function radius_admin_header_style() {

	$headimg = sprintf( '.appearance_page_custom-header #headimg { background-repeat:no-repeat; border:none !important; width: %spx; height: %spx; }', HEADER_IMAGE_WIDTH, HEADER_IMAGE_HEIGHT );
	printf( '<style type="text/css">%1$s</style>', $headimg );

}
?>