<?php
/**
 * The core functions file for the Radius framework. Functions defined here are generally
 * used across the entire framework to make various tasks faster. This file should be loaded
 * prior to any other files because its functions are needed to run the framework.
 *
 * @package Radius
 * @subpackage Functions
 */

/** Function for setting the content width of a theme. */
function radius_set_content_width( $width = '' ) {
	global $content_width;
	$content_width = absint( $width );
}

/** Function for getting the theme's content width. */
function radius_get_content_width() {
	global $content_width;
	return $content_width;
}

/** Gets theme data */
function radius_get_theme_data( $path = 'template' ) {
	global $radius;
	
	/* If 'template' is requested, get the parent theme data. */
	if ( 'template' == $path ) {

		/* If the parent theme data isn't set, grab it with the get_theme_data() function. */
		if ( empty( $radius->theme_data ) ) {
			$radius->theme_data = get_theme_data( trailingslashit( RADIUS_DIR ) . 'style.css' );
		}

		/* Return the parent theme data. */
		return $radius->theme_data;
	}	

	/* Return false for everything else. */
	return false;
}
?>