<?php
/**
 * Theme Functions
 *
 * @package Bretheon
 * @author Muffin group
 * @link http://muffingroup.com
 */


define('THEME_DIR', get_template_directory());
define('THEME_URI', get_template_directory_uri());

define('THEME_NAME', 'Bretheon');
define('THEME_VERSION', '2.0.2');

define('LIBS_DIR', THEME_DIR. '/functions');
define('LIBS_URI', THEME_URI. '/functions');
define('LANG_DIR', THEME_DIR. '/languages');

add_filter('widget_text', 'do_shortcode');


/* ---------------------------------------------------------------------------
 * Loads Theme Textdomain
 * --------------------------------------------------------------------------- */
load_theme_textdomain( 'bretheon', LANG_DIR );
load_theme_textdomain( 'mfn-opts', LANG_DIR );


/* ---------------------------------------------------------------------------
 * Loads the Options Panel
 * --------------------------------------------------------------------------- */
function mfn_sortable() {
	wp_enqueue_script('jquery-ui-sortable');
}    
add_action('wp_enqueue_scripts', 'mfn_sortable');
add_action('admin_enqueue_scripts', 'mfn_sortable');
	
require( THEME_DIR . '/muffin-options/theme-options.php' );


/* ---------------------------------------------------------------------------
 * Loads Theme Functions
 * --------------------------------------------------------------------------- */

// Functions --------------------------------------------------------------------
require_once(LIBS_DIR.'/theme-functions.php');

// Header -----------------------------------------------------------------------
require_once(LIBS_DIR.'/theme-head.php');

// Menu -------------------------------------------------------------------------
require_once(LIBS_DIR.'/theme-menu.php');

// Meta box ---------------------------------------------------------------------
require_once(LIBS_DIR.'/meta-functions.php');
require_once(LIBS_DIR.'/meta-page.php');
require_once(LIBS_DIR.'/meta-post.php');

// Custom post types ------------------------------------------------------------
require_once(LIBS_DIR.'/meta-client.php');
require_once(LIBS_DIR.'/meta-offer.php');
require_once(LIBS_DIR.'/meta-portfolio.php');
require_once(LIBS_DIR.'/meta-slide.php');

// Shortcodes -------------------------------------------------------------------
require_once(LIBS_DIR.'/theme-shortcodes.php');

// Widgets ----------------------------------------------------------------------
require_once(LIBS_DIR.'/widget-functions.php');
require_once(LIBS_DIR.'/widget-clients.php');
require_once(LIBS_DIR.'/widget-flickr.php');
require_once(LIBS_DIR.'/widget-menu.php');
require_once(LIBS_DIR.'/widget-recent-comments.php');
require_once(LIBS_DIR.'/widget-recent-posts.php');
require_once(LIBS_DIR.'/widget-tag-cloud.php');
require_once(LIBS_DIR.'/widget-twitter.php');

// Plugins ---------------------------------------------------------------------- 
require_once(LIBS_DIR.'/plugins/dropdown-menus.php');

// TinyMCE ---------------------------------------------------------------------- 
require_once(LIBS_DIR.'/tinymce/tinymce.php');

// Theme Activation Hook -------------------------------------------------------- 
require_once ( get_template_directory()  . '/functions/theme-activation-hook.php' );

// Revolution slider ------------------------------------------------------------ 
if( ! in_array( 'revslider/revslider.php', (array) get_option( 'active_plugins', array() ) ) ) {
	require_once ( THEME_DIR .'/revslider/revslider.php' );
}

?>